﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace photogallery
{
    public partial class Form1 : Form
    {
        string[] pictures = new string[0];      // The path locations of all pictures loaded
        int selectedIndex = 0;                  // The index currently being displayed

        public Form1()
        {
            InitializeComponent();
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Are you sure you wish to exit the photo gallery?", "Confirm", 
                MessageBoxButtons.YesNo) == System.Windows.Forms.DialogResult.Yes)
            {
                this.Close();   // If confirmed, close the application
            }
        }

        private void loadButton_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folder = new FolderBrowserDialog();
            if (folder.ShowDialog() == System.Windows.Forms.DialogResult.OK) // if directory selected...
            {
                pictures = Directory.GetFiles(folder.SelectedPath);     // retrieve all files in directory
                pictures = removeMiscPaths(pictures);                   // remove all non-png/jpg files
                this.Text = "Photo Gallery - " + folder.SelectedPath;   // update title of form

                selectedIndex = 0;                                      // update selected index and update image
                updateImage();
            }
        }

        private void leftButton_Click(object sender, EventArgs e)
        {
            if (pictures.Count() > 0)                       // if there are loaded pictures
            {
                if (selectedIndex > 0)                      
                    selectedIndex--;                        // if still in bounds, decrease index
                updateImage();                              // update the image
            }
        }

        private void rightButton_Click(object sender, EventArgs e)
        {
            if (pictures.Count() > 0)                       // if there are loaded pictures
            {
                if (selectedIndex < pictures.Count() - 1)
                    selectedIndex++;                        // if still in bounds, increase index
                updateImage();                              // update the image
            }
        }

        void updateImage()
        {
            // format the position label as followed : {index of current image} / {number of pictures}
            positionLabel.Text = (selectedIndex + 1).ToString() + " / " + pictures.Count();
            galleryBox.Load(pictures[selectedIndex]);  // Load new image
            leftButton.Enabled = true;
            rightButton.Enabled = true;
        }

        string[] removeMiscPaths(string[] paths)
        {
            List<string> newPaths = new List<string>();
            for (int i = 0; i < paths.Count(); i++ )            // for each path in paths...
            {
                string extension = paths[i].Split('.')[1];      // grab extension
                if (extension == "jpg" || extension == "png")   // if extension is valid, add path to list
                    newPaths.Add(paths[i]);
            }
            return newPaths.ToArray();                          // return path list as an array
        }
    }
}
